/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.ui.editor.outline;

import com.aptana.editor.php.PHPEditorPlugin;
import com.aptana.editor.php.internal.parser.nodes.PHPBaseParseNode;
import com.aptana.editor.php.internal.ui.editor.outline.AbstractComposingLabelDecorator;
import com.aptana.editor.php.internal.ui.editor.outline.PHPOutlineItem;
import com.aptana.parsing.ast.IParseNode;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org2.eclipse.php.core.compiler.PHPFlags;

public class PHPOutlineLabelDecorator
extends AbstractComposingLabelDecorator {
    private static final ImageDescriptor STATIC_IMAGE_DESCRIPTOR = PHPEditorPlugin.getImageDescriptor("icons/full/ovr16/static_co.png");
    private static final ImageDescriptor FINAL_IMAGE_DESCRIPTOR = PHPEditorPlugin.getImageDescriptor("icons/full/ovr16/final_co.png");
    private static final ImageDescriptor ABSTRACT_IMAGE_DESCRIPTOR = PHPEditorPlugin.getImageDescriptor("icons/full/ovr16/abstract_co.png");

    public PHPOutlineLabelDecorator(int width, int height) {
        super(width, height);
    }

    @Override
    protected Object getCompositionKey(Image image, Object element) {
        if (image == null || element == null) {
            return null;
        }
        PHPBaseParseNode node = this.getPHPNode(element);
        if (node == null) {
            return null;
        }
        int imageHashCode = image.hashCode();
        int modifiers = node.getModifiers();
        long key = ((long)imageHashCode << 32) + (long)modifiers;
        return key;
    }

    protected PHPBaseParseNode getPHPNode(Object element) {
        if (!(element instanceof PHPOutlineItem)) {
            return null;
        }
        PHPOutlineItem outlineItem = (PHPOutlineItem)((Object)element);
        IParseNode referenceNode = outlineItem.getReferenceNode();
        if (referenceNode instanceof PHPBaseParseNode) {
            return (PHPBaseParseNode)referenceNode;
        }
        return null;
    }

    @Override
    public Image compose(Image mainImage, Object element) {
        ImageDescriptor[] descriptors = new ImageDescriptor[5];
        PHPBaseParseNode phpNode = this.getPHPNode(element);
        if (phpNode == null) {
            return mainImage;
        }
        int modifiers = phpNode.getModifiers();
        if (PHPFlags.isAbstract((int)modifiers)) {
            descriptors[1] = ABSTRACT_IMAGE_DESCRIPTOR;
            if (PHPFlags.isStatic((int)modifiers)) {
                descriptors[0] = STATIC_IMAGE_DESCRIPTOR;
            }
        } else if (PHPFlags.isFinal((int)modifiers)) {
            descriptors[1] = FINAL_IMAGE_DESCRIPTOR;
            if (PHPFlags.isStatic((int)modifiers)) {
                descriptors[0] = STATIC_IMAGE_DESCRIPTOR;
            }
        } else if (PHPFlags.isStatic((int)modifiers)) {
            descriptors[1] = STATIC_IMAGE_DESCRIPTOR;
        }
        if (descriptors[1] != null) {
            return new DecorationOverlayIcon(mainImage, descriptors, new Point(this.width, this.height)).createImage();
        }
        return mainImage;
    }
}

